<?php
// Funkcja wywietlajca wielowymiarow tablic w postaci tekstowych kolumn.  
// Argument $spacing naley ustawi na liczb spacji oddzielajcych kolumny.
function display_array($arr, $spacing) {
    // Trzeba okreli maksymaln szeroko kadej kolumny w tablicy. 
    $widths = array();
    
    // Przetwarzanie wszystkich wierszy w ptli. 
    foreach ($arr as $row) {
        // Analiza poszczeglnych kolumn.
        foreach ($row as $key => $col) {
            // Jeli okrelona pozycja jest szersza od innych w okrelonej kolumnie  zapisanie jej.
            if (!isset($widths[$key]) || (strlen($col) > $widths[$key])) {
                $widths[$key] = strlen($col);
            }
        }
    }
    
    // Po wyznaczeniu maksymalnych szerokoci mona przetworzy tablic 
    //  w ptli i wywietli poszczeglne wiersze.
    echo '<pre>';
    foreach ($arr as $row) {
        $count = 0;
        foreach ($row as $key => $col) {
            // Dodanie odstpu, jeli to nie jest pierwsza kolumna:
            if ($count++) {
                echo str_repeat(' ', $spacing);
            }
            
            // Wywietlenie kolumny uzupenionej waciw liczb spacji.
            echo str_pad($col, $widths[$key]);
        }
        echo "\n";
    }
}

$test_array = array(
    array('NAZWISKO', 'MIASTO', 'WOJEWDZTWO', 'TELEFON', 'EMAIL'),
    array('Bogdan Kowalski', 'Bydgoszcz', 'KP', '410-555-1212', 'bk@poczta.pl'),
    array('Janina Domarska', 'Gdask', 'PO', '999-555-7136', 'janina@tarzan.pl'),
    array('Wacaw Filipiak', 'Radom', 'MZ', 
            '123-555-4567', 'wacek@filipiakowie.pl'),
    array('Stefan Pracowity', 'Cieszyn', 'SL', 
            '023-555-4991', 'pracus@orange.pl')
    );

// Wywoanie funkcji dla tablicy $test_array spowoduje wywietlenie nastpujcego wyniku:
//NAZWISKO          MIASTO     WOJEWDZTWO  TELEFON       EMAIL                
//Bogdan Kowalski   Bydgoszcz  KP           410-555-1212  bk@poczta.pl         
//Janina Domarska   Gdask     PO           999-555-7136  janina@tarzan.pl     
//Wacaw Filipiak   Radom      MZ           123-555-4567  wacek@filipiakowie.pl
//Stefan Pracowity  Cieszyn    SL           023-555-4991  pracus@orange.pl     
display_array($test_array, 2);
?>
